from SPARQLWrapper import SPARQLWrapper, JSON
import time
import traceback
import sys

# requires python-sparqlwrapper
# sudo apt-get install python-sparqlwrapper

if(len(sys.argv)!=4) :
    print("Args: queryFile endpoint timeout")
    sys.exit()

sparql = SPARQLWrapper(sys.argv[2])
sparql.setTimeout(int(sys.argv[3]))
sparql.setReturnFormat(JSON)

queries_file = open(sys.argv[1], "r")

queries = []
for line in queries_file:
    q = line.strip();
    if len(q.strip()) > 0 :
        queries.append(line.strip())

query_number = 1
for query in queries:
    count = 0
    start_time = time.time()
    try:
        sparql.setQuery(query)
        results = sparql.query()

        end_time = time.time()
        elapsed_time = int((end_time - start_time)*1000000000)

        json_results = results.convert()
        for result in json_results["results"]["bindings"]:
            count += 1

        print("{0};{1};{2}".format(query_number, count, elapsed_time))
    except Exception as e:
        end_time = time.time()
        elapsed_time = int((end_time - start_time)*1000000000)

        print("{0};-1;{1}".format(query_number, elapsed_time))
        traceback.print_exc()
    query_number += 1

queries_file.close();